/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.accds.feign.util;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class VerifyPair<I, R> {
    private I issuer;
    private List<R> receivers;

    public VerifyPair() {
        this.receivers = new ArrayList<R>();
    }

    public VerifyPair(I issuer, R receiver) {
        this.issuer = issuer;
        this.receivers = new ArrayList<R>();
        if (receiver != null) {
            this.receivers.add(receiver);
        }
    }

    public VerifyPair(I issuer, List<R> receivers) {
        this.issuer = issuer;
        this.receivers = receivers != null ? new ArrayList<R>(receivers) : new ArrayList();
    }

    public void addReceiver(R receiver) {
        if (receiver != null) {
            this.receivers.add(receiver);
        }
    }

    public List<R> getAllReceivers() {
        return new ArrayList<R>(this.receivers);
    }

    public int getReceiverCount() {
        return this.receivers.size();
    }

    public boolean isComplete() {
        return this.issuer != null && !this.receivers.isEmpty();
    }

    public boolean isEmpty() {
        return this.issuer == null && this.receivers.isEmpty();
    }

    public boolean hasIssuer() {
        return this.issuer != null;
    }

    public boolean hasReceiver() {
        return !this.receivers.isEmpty();
    }

    public boolean hasMultipleReceivers() {
        return this.receivers.size() > 1;
    }

    public String toString() {
        return "VerifyPair{issuer=" + this.issuer + ", receivers=" + this.receivers + ", receiverCount=" + this.receivers.size() + '}';
    }

    @Generated
    public void setIssuer(I issuer) {
        this.issuer = issuer;
    }

    @Generated
    public void setReceivers(List<R> receivers) {
        this.receivers = receivers;
    }

    @Generated
    public I getIssuer() {
        return this.issuer;
    }

    @Generated
    public List<R> getReceivers() {
        return this.receivers;
    }
}

