/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverAccountBaseDO;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.invord.issuerDetail.InvOrdRIDetailDO;
import com.jiuqi.accds.feign.domain.vo.InvOrdReceiverVO;
import com.jiuqi.accds.feign.issuerentity.common.InformationOfTaxableGoodsOrServicesDetailItemsTuple;
import com.jiuqi.accds.feign.issuerentity.invord.InvOrdIssuer;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.common.AccdsErrorDataEnum;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.domain.entity.InvOrdInvReceiver;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.util.AccountDataManageUtil;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.DataUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvOrdHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InvOrdHandle.class);

    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        UploadFileDO issuerFile = pair.getIssuer();
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        if (ObjectUtils.isEmpty(issuerFile) || CollectionUtils.isEmpty(receiverFiles)) {
            throw new ValidateException(AccdsErrorDataEnum.ERROR_XML.getValue());
        }
        String issXml = issuerFile.getContent();
        InvOrdIssuer invOrdIssuer = CommonUtils.xbrlToObject("inv_ord_issuer", issXml, new TypeReference<InvOrdIssuer>(this){});
        if (ObjectUtils.isEmpty(invOrdIssuer)) {
            throw new ValidateException(AccdsErrorDataEnum.ERROR_XML.getValue());
        }
        String issuniqueCodeOfInvoice = invOrdIssuer.getUniqueCodeOfInvoice();
        for (UploadFileDO receiverFile : receiverFiles) {
            try {
                this.processReceiverFile(receiverFileParamsDTO, invOrdIssuer, receiverFile, issuniqueCodeOfInvoice);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                throw new ValidateException("\u5904\u7406\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private void processReceiverFile(ReceiverFileParamsDTO receiverFileParamsDTO, InvOrdIssuer invOrdIssuer, UploadFileDO receiverFile, String issuniqueCodeOfInvoice) {
        boolean checkStatus;
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        String receiverXml = receiverFile.getContent();
        InvOrdInvReceiver invOrdInvReceiver = CommonUtils.xbrlToObject("inv_ord_receiver", receiverXml, new TypeReference<InvOrdInvReceiver>(this){});
        if (ObjectUtils.isEmpty(invOrdInvReceiver)) {
            throw new ValidateException(AccdsErrorDataEnum.ERROR_XML.getValue());
        }
        String recuniqueCodeOfInvoice = invOrdInvReceiver.getUniqueCodeOfInvoice();
        if (ObjectUtils.isEmpty(issuniqueCodeOfInvoice) || ObjectUtils.isEmpty(recuniqueCodeOfInvoice) || !issuniqueCodeOfInvoice.equals(recuniqueCodeOfInvoice)) {
            throw new ValidateException("\u3010\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u7535\u5b50\u51ed\u8bc1\u4e0e\u751f\u6210\u7684\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u552f\u4e00\u6807\u8bc6 uniqueCodeOfInvoice\uff08\u53d1\u7968\u552f\u4e00\u6807\u8bc6\uff09\u4e0d\u4e00\u81f4,\u8bf7\u6838\u67e5issuer.xml\u548creceiver.xml\u3011");
        }
        if (!unioncode.equals(invOrdIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u7968\u636e\u6587\u4ef6\u3011\u3010\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u7968\u636e\u6587\u4ef6\uff1a" + invOrdIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser() + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        if (!unioncode.equals(invOrdInvReceiver.getUnifiedSocialCreditCodeOfAccountingEntity()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011 \u51ed\u8bc1\u6587\u4ef6\uff1a" + invOrdInvReceiver.getUnifiedSocialCreditCodeOfAccountingEntity() + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        if (isCheckNull && !(checkStatus = this.checkUniformity(invOrdIssuer, invOrdInvReceiver))) {
            throw new ValidateException(AccdsErrorDataEnum.ERROR_UF.getValue());
        }
        InvOrdReceiverVO invOrdReceiverVO = new InvOrdReceiverVO();
        this.bill(invOrdIssuer, invOrdReceiverVO);
        ArrayList<UploadFileDO> tempList = new ArrayList<UploadFileDO>();
        tempList.add(receiverFile);
        this.account(unitcode, isCheckNull, invOrdInvReceiver, issuniqueCodeOfInvoice, recuniqueCodeOfInvoice, invOrdReceiverVO, fileId);
    }

    private boolean checkUniformity(InvOrdIssuer invOrdIssuer, InvOrdInvReceiver invOrdInvReceiver) {
        if (!Objects.equals(invOrdIssuer.getNameOfSeller(), invOrdInvReceiver.getNameOfSeller())) {
            return false;
        }
        if (!Objects.equals(invOrdIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller(), invOrdInvReceiver.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller())) {
            return false;
        }
        if (!Objects.equals(invOrdIssuer.getTotalAmountExcludingTax(), invOrdInvReceiver.getTotalAmountExcludingTax())) {
            return false;
        }
        if (!Objects.equals(invOrdIssuer.getTotalTaxAmount(), invOrdInvReceiver.getTotalTaxAmount())) {
            return false;
        }
        if (!Objects.equals(invOrdIssuer.getTaxIncludedAmountInFigures(), invOrdInvReceiver.getTaxIncludedAmountInFigures())) {
            return false;
        }
        return Objects.equals(invOrdIssuer.getDateOfIssue(), invOrdInvReceiver.getDateOfIssue());
    }

    private void bill(InvOrdIssuer invOrdIssuer, InvOrdReceiverVO invOrdReceiverVO) {
        invOrdReceiverVO.setInvoicetype(invOrdIssuer.getTypeOfInvoice());
        invOrdReceiverVO.setUniquecode(invOrdIssuer.getUniqueCodeOfInvoice());
        invOrdReceiverVO.setLocations(invOrdIssuer.getLocationOfInvoice());
        invOrdReceiverVO.setInvoicecode(invOrdIssuer.getCodeOfInvoice());
        invOrdReceiverVO.setInvoicenumber(invOrdIssuer.getNumberOfInvoice());
        invOrdReceiverVO.setIssuedate(ObjectUtils.isEmpty(invOrdIssuer.getDateOfIssue()) ? null : invOrdIssuer.getDateOfIssue());
        invOrdReceiverVO.setIdentifycode(invOrdIssuer.getIdentifyingCode());
        invOrdReceiverVO.setSpecialinvoicetype(invOrdIssuer.getSpecialInvoiceType());
        invOrdReceiverVO.setInvoicemachine(invOrdIssuer.getNumberOfInvoiceMachine());
        invOrdReceiverVO.setInvoiceissuingsign(invOrdIssuer.getInvoiceIssuingSign());
        invOrdReceiverVO.setPurchasername(invOrdIssuer.getNameOfPurchaser());
        invOrdReceiverVO.setPurtaxpayeridentification(invOrdIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser());
        invOrdReceiverVO.setPurcapn(invOrdIssuer.getAddressPhoneNumberOfPurchaser());
        invOrdReceiverVO.setPurdepositban(invOrdIssuer.getDepositBankAndAccountNumberOfPurchaser());
        invOrdReceiverVO.setSecuritycode(invOrdIssuer.getSecurityCode());
        invOrdReceiverVO.setTotalamount(CommonUtils.stringToBigDecimal(invOrdIssuer.getTotalAmountExcludingTax()));
        invOrdReceiverVO.setTotaltaxamount(CommonUtils.stringToBigDecimal(invOrdIssuer.getTotalTaxAmount()));
        invOrdReceiverVO.setTaxpriceup(invOrdIssuer.getTaxIncludedAmountInWords());
        invOrdReceiverVO.setTaxpricelow(CommonUtils.stringToBigDecimal(invOrdIssuer.getTaxIncludedAmountInFigures()));
        invOrdReceiverVO.setSellername(invOrdIssuer.getNameOfSeller());
        invOrdReceiverVO.setSeltaxpayeridentification(invOrdIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller());
        invOrdReceiverVO.setSelcapn(invOrdIssuer.getAddressPhoneNumberOfSeller());
        invOrdReceiverVO.setSeldepositban(invOrdIssuer.getDepositBankAndAccountNumberOfSeller());
        invOrdReceiverVO.setRemarks(invOrdIssuer.getRemarks());
        invOrdReceiverVO.setPayee(invOrdIssuer.getPayee());
        invOrdReceiverVO.setReviewer(invOrdIssuer.getReviewer());
        invOrdReceiverVO.setIssuer(invOrdIssuer.getIssuer());
        String begin = invOrdIssuer.getBeginningOfIncomePeriodUnderAccrualBasis();
        invOrdReceiverVO.setBeginacc(StringUtils.hasText(begin) ? Integer.valueOf(begin.replace("-", "")) : null);
        String end = invOrdIssuer.getEndOfIncomePeriodUnderAccrualBasis();
        invOrdReceiverVO.setEndacc(StringUtils.hasText(end) ? Integer.valueOf(end.replace("-", "")) : null);
        invOrdReceiverVO.setOriginalinvoicecode(invOrdIssuer.getCodeOfOriginalInvoice());
        invOrdReceiverVO.setOriginalinvoicenum(invOrdIssuer.getNumberOfOriginalInvoice());
        invOrdReceiverVO.setRushredreason(invOrdIssuer.getReasonOfRushRed());
        List<InformationOfTaxableGoodsOrServicesDetailItemsTuple> list = invOrdIssuer.getInformationOfTaxableGoodsOrServicesDetailItemsTuple();
        if (!CollectionUtils.isEmpty(list)) {
            List<InvOrdRIDetailDO> detailList = list.stream().map(item -> DataUtils.getDetail(item, new TypeReference<InvOrdRIDetailDO>(this){})).collect(Collectors.toList());
            invOrdReceiverVO.setIssuerDetailList(detailList);
        }
    }

    private boolean account(String unitcode, boolean isCheckNull, InvOrdInvReceiver invOrdInvReceiver, String issuniqueCodeOfInvoice, String recuniqueCodeOfInvoice, InvOrdReceiverVO invOrdReceiverVO, String fileId) {
        String whetherInvoiceIsRedInvoice = invOrdInvReceiver.getWhetherInvoiceIsRedInvoice();
        String whetherInvoiceHasBeenChecked = invOrdInvReceiver.getWhetherInvoiceHasBeenChecked();
        String whetherInvoiceHasBeenBooked = invOrdInvReceiver.getWhetherInvoiceHasBeenBooked();
        String unifiedSocialCreditCodeOfAccountingEntity = invOrdInvReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        String nameOfAccountingEntity = invOrdInvReceiver.getNameOfAccountingEntity();
        List<InformationOfAccountingDocumentsTuple> accountList = invOrdInvReceiver.getInformationOfAccountingDocumentsTuple();
        String nameOfSeller = invOrdInvReceiver.getNameOfSeller();
        String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = invOrdInvReceiver.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller();
        String totalAmountExcludingTax = invOrdInvReceiver.getTotalAmountExcludingTax();
        String totalTaxAmount = invOrdInvReceiver.getTotalTaxAmount();
        String taxIncludedAmountInFigures = invOrdInvReceiver.getTaxIncludedAmountInFigures();
        Date dateOfIssue = invOrdInvReceiver.getDateOfIssue();
        ArrayList<String> resultList = new ArrayList<String>();
        if (isCheckNull) {
            StringBuilder stringBuilder;
            int flag = 0;
            if (!StringUtils.hasText(recuniqueCodeOfInvoice) || recuniqueCodeOfInvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010uniqueCodeOfInvoice\uff08\u53d1\u7968\u552f\u4e00\u6807\u8bc6\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfSeller) || nameOfSeller.equals("null")) {
                flag = 2;
                resultList.add("\u3010NameOfSeller\uff08\u9500\u552e\u65b9\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller) || taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller.equals("null")) {
                flag = 2;
                resultList.add("\u3010taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller\uff08\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff08\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(totalAmountExcludingTax) || totalAmountExcludingTax.equals("null")) {
                flag = 2;
                resultList.add("\u3010totalAmountExcludingTax\uff08\u4e0d\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(totalTaxAmount) || totalTaxAmount.equals("null")) {
                flag = 2;
                resultList.add("\u3010totalTaxAmount\uff08\u7a0e\u989d\u5408\u8ba1\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(taxIncludedAmountInFigures) || taxIncludedAmountInFigures.equals("null")) {
                flag = 2;
                resultList.add("\u3010taxIncludedAmountInFigures\uff08\u4ef7\u7a0e\u5408\u8ba1\uff08\u5c0f\u5199\uff09\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty(dateOfIssue)) {
                flag = 2;
                resultList.add("\u3010dateOfIssue\uff08\u5f00\u7968\u65e5\u671f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceIsRedInvoice) || whetherInvoiceIsRedInvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceIsRedInvoice\uff08\u662f\u5426\u7ea2\u5b57\u53d1\u7968\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenChecked) || whetherInvoiceHasBeenChecked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenChecked\uff08\u662f\u5426\u5df2\u9a8c\u771f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenBooked) || whetherInvoiceHasBeenBooked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenBooked\uff08\u662f\u5426\u5df2\u5165\u8d26\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(unifiedSocialCreditCodeOfAccountingEntity) || unifiedSocialCreditCodeOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010unifiedSocialCreditCodeOfAccountingEntity\uff08\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfAccountingEntity) || nameOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010nameOfAccountingEntity\uff08\u4f1a\u8ba1\u5355\u4f4d\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty(accountList) && (stringBuilder = AccountDataManageUtil.checkAccountData(accountList)).length() > 0) {
                resultList.add(stringBuilder.toString());
                flag = 2;
            }
            if (flag == 2) {
                throw new ValidateException("\u666e\u7968\u5fc5\u586b\u9879\u68c0\u67e5\u672a\u901a\u8fc7: " + String.join((CharSequence)", ", resultList));
            }
        }
        invOrdReceiverVO.setUniquecode(invOrdInvReceiver.getUniqueCodeOfInvoice());
        invOrdReceiverVO.setContractnumber(invOrdInvReceiver.getContractNumber());
        invOrdReceiverVO.setMatchingstate(invOrdInvReceiver.getMatchingStateBetweenBusinessDocumentsAndVatEInvoice());
        invOrdReceiverVO.setEamdprctmethods(invOrdInvReceiver.getDepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets());
        invOrdReceiverVO.setRedinvoice(whetherInvoiceIsRedInvoice);
        invOrdReceiverVO.setBeenchecked(whetherInvoiceHasBeenChecked);
        invOrdReceiverVO.setBeenbooked(whetherInvoiceHasBeenBooked);
        invOrdReceiverVO.setBeenpaid(invOrdInvReceiver.getWhetherInvoiceHasBeenPaid());
        invOrdReceiverVO.setElecreceiptnumber(invOrdInvReceiver.getNumberOfBankElectronicReceipt());
        invOrdReceiverVO.setSocialcreditcode(unifiedSocialCreditCodeOfAccountingEntity);
        invOrdReceiverVO.setAccountname(nameOfAccountingEntity);
        invOrdReceiverVO.setBeginaccrual(invOrdInvReceiver.getBeginningOfExpenditurePeriodUnderAccrualBasis());
        invOrdReceiverVO.setEndaccrual(invOrdInvReceiver.getEndOfExpenditurePeriodUnderAccrualBasis());
        invOrdReceiverVO.setBeencompleted(invOrdInvReceiver.getWhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted());
        invOrdReceiverVO.setBeginincometax(invOrdInvReceiver.getBeginningOfPreTaxDeductionYearOfIncomeTax());
        invOrdReceiverVO.setEndincometax(invOrdInvReceiver.getEndOfPreTaxDeductionYearOfIncomeTax());
        invOrdReceiverVO.setSecuritized(invOrdInvReceiver.getWhetherInvoiceHasBeenFactoredSoldOrSecuritized());
        invOrdReceiverVO.setUnitcode(unitcode);
        invOrdReceiverVO.setRecnameofseller(nameOfSeller);
        invOrdReceiverVO.setRectaxpayerident(taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller);
        invOrdReceiverVO.setRectotalamountexcludingtax(CommonUtils.stringToBigDecimal(totalAmountExcludingTax));
        invOrdReceiverVO.setRectotaltaxamount(CommonUtils.stringToBigDecimal(totalTaxAmount));
        invOrdReceiverVO.setRectaxincludedamountinfigures(CommonUtils.stringToBigDecimal(taxIncludedAmountInFigures));
        invOrdReceiverVO.setRecdateofissue(dateOfIssue);
        if (!CollectionUtils.isEmpty(accountList)) {
            List<ReceiverAccountBaseDO> detailList = AccountDataManageUtil.setAccountData(accountList);
            invOrdReceiverVO.setAccountList(detailList);
        }
        return true;
    }
}

