/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverAccountBaseDO;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.invspcl.issuerDetail.InvSpclRIDetailDO;
import com.jiuqi.accds.feign.domain.vo.InvSpclReceiverVO;
import com.jiuqi.accds.feign.issuerentity.common.InformationOfTaxableGoodsOrServicesDetailItemsTuple;
import com.jiuqi.accds.feign.issuerentity.invspcl.InvSpclIssuer;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.domain.entity.InvSpclInvReceiver;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.util.AccountDataManageUtil;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.DataUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvSpclHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InvSpclHandle.class);

    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        UploadFileDO issuerFile = pair.getIssuer();
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        if (ObjectUtils.isEmpty(issuerFile) || CollectionUtils.isEmpty(receiverFiles)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String issXml = issuerFile.getContent();
        InvSpclIssuer invSpclIssuer = CommonUtils.xbrlToObject("inv_spcl_issuer", issXml, new TypeReference<InvSpclIssuer>(this){});
        if (ObjectUtils.isEmpty(invSpclIssuer)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String issuniqueCodeOfInvoice = invSpclIssuer.getUniqueCodeOfInvoice();
        for (UploadFileDO receiverFile : receiverFiles) {
            try {
                this.processReceiverFile(receiverFileParamsDTO, invSpclIssuer, receiverFile, issuniqueCodeOfInvoice);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u6570\u7535\u7968(\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968)\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                throw new ValidateException("\u5904\u7406\u6570\u7535\u7968(\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968)\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private void processReceiverFile(ReceiverFileParamsDTO receiverFileParamsDTO, InvSpclIssuer invSpclIssuer, UploadFileDO receiverFile, String issuniqueCodeOfInvoice) {
        boolean checkStatus;
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        String receiverXml = receiverFile.getContent();
        InvSpclInvReceiver invSpclInvReceiver = CommonUtils.xbrlToObject("inv_spcl_receiver", receiverXml, new TypeReference<InvSpclInvReceiver>(this){});
        if (ObjectUtils.isEmpty(invSpclInvReceiver)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String recuniqueCodeOfInvoice = invSpclInvReceiver.getUniqueCodeOfInvoice();
        if (ObjectUtils.isEmpty(issuniqueCodeOfInvoice) || ObjectUtils.isEmpty(recuniqueCodeOfInvoice) || !issuniqueCodeOfInvoice.equals(recuniqueCodeOfInvoice)) {
            throw new ValidateException("\u3010\u6570\u7535\u7968(\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968)\u7535\u5b50\u51ed\u8bc1\u4e0e\u751f\u6210\u7684\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u552f\u4e00\u6807\u8bc6 uniqueCodeOfInvoice\uff08\u53d1\u7968\u552f\u4e00\u6807\u8bc6\uff09\u4e0d\u4e00\u81f4,\u8bf7\u6838\u67e5issuer.xml\u548creceiver.xml\u3011");
        }
        String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser = invSpclIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser();
        if (!unioncode.equals(invSpclIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u7968\u636e\u6587\u4ef6\u3011\u3010\u6570\u7535\u7968(\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968)\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u7968\u636e\u6587\u4ef6\uff1a" + taxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        String unifiedSocialCreditCode = invSpclInvReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        if (!unioncode.equals(unifiedSocialCreditCode) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u6570\u7535\u7968(\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968)\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u51ed\u8bc1\u6587\u4ef6\uff1a" + unifiedSocialCreditCode + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        if (isCheckNull && !(checkStatus = this.checkUniformity(invSpclIssuer, invSpclInvReceiver))) {
            throw new ValidateException("\u5f00\u5177\u65b9\u63a5\u6536\u65b9\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u672a\u901a\u8fc7");
        }
        InvSpclReceiverVO invSpclReceiverVO = new InvSpclReceiverVO();
        this.bill(invSpclIssuer, invSpclReceiverVO);
        this.account(unitcode, isCheckNull, invSpclInvReceiver, recuniqueCodeOfInvoice, invSpclReceiverVO);
    }

    private boolean checkUniformity(InvSpclIssuer invSpclIssuer, InvSpclInvReceiver invSpclInvReceiver) {
        if (!Objects.equals(invSpclIssuer.getNameOfSeller(), invSpclInvReceiver.getNameOfSeller())) {
            return false;
        }
        if (!Objects.equals(invSpclIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller(), invSpclInvReceiver.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller())) {
            return false;
        }
        if (!Objects.equals(invSpclIssuer.getTotalAmountExcludingTax(), invSpclInvReceiver.getTotalAmountExcludingTax())) {
            return false;
        }
        if (!Objects.equals(invSpclIssuer.getTotalTaxAmount(), invSpclInvReceiver.getTotalTaxAmount())) {
            return false;
        }
        if (!Objects.equals(invSpclIssuer.getTaxIncludedAmountInFigures(), invSpclInvReceiver.getTaxIncludedAmountInFigures())) {
            return false;
        }
        return Objects.equals(invSpclIssuer.getDateOfIssue(), invSpclInvReceiver.getDateOfIssue());
    }

    private boolean account(String unitcode, boolean isCheckNull, InvSpclInvReceiver invSpclInvReceiver, String recuniqueCodeOfInvoice, InvSpclReceiverVO invSpclReceiverVO) {
        String whetherInvoiceIsRedInvoice = invSpclInvReceiver.getWhetherInvoiceIsRedInvoice();
        String whetherInvoiceHasBeenChecked = invSpclInvReceiver.getWhetherInvoiceHasBeenChecked();
        String whetherInvoiceHasBeenBooked = invSpclInvReceiver.getWhetherInvoiceHasBeenBooked();
        String unifiedSocialCreditCodeOfAccountingEntity = invSpclInvReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        String nameOfAccountingEntity = invSpclInvReceiver.getNameOfAccountingEntity();
        String whetherInputVatHasBeenTransferredOut = invSpclInvReceiver.getWhetherInputVatHasBeenTransferredOut();
        String amountOfTransferredOutInputVat = invSpclInvReceiver.getAmountOfTransferredOutInputVat();
        String whetherInvoiceUsageHasBeenConfirmed = invSpclInvReceiver.getWhetherInvoiceUsageHasBeenConfirmed();
        List<InformationOfAccountingDocumentsTuple> accountList = invSpclInvReceiver.getInformationOfAccountingDocumentsTuple();
        String nameOfSeller = invSpclInvReceiver.getNameOfSeller();
        String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = invSpclInvReceiver.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller();
        String totalAmountExcludingTax = invSpclInvReceiver.getTotalAmountExcludingTax();
        String totalTaxAmount = invSpclInvReceiver.getTotalTaxAmount();
        String taxIncludedAmountInFigures = invSpclInvReceiver.getTaxIncludedAmountInFigures();
        Date dateOfIssue = invSpclInvReceiver.getDateOfIssue();
        ArrayList<String> resultList = new ArrayList<String>();
        if (isCheckNull) {
            StringBuilder stringBuilder;
            int flag = 0;
            if (!StringUtils.hasText(recuniqueCodeOfInvoice) || recuniqueCodeOfInvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010uniqueCodeOfInvoice\uff08\u53d1\u7968\u552f\u4e00\u6807\u8bc6\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfSeller) || nameOfSeller.equals("null")) {
                flag = 2;
                resultList.add("\u3010NameOfSeller\uff08\u9500\u552e\u65b9\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller) || taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller.equals("null")) {
                flag = 2;
                resultList.add("\u3010taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller\uff08\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff08\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(totalAmountExcludingTax) || totalAmountExcludingTax.equals("null")) {
                flag = 2;
                resultList.add("\u3010totalAmountExcludingTax\uff08\u4e0d\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(totalTaxAmount) || totalTaxAmount.equals("null")) {
                flag = 2;
                resultList.add("\u3010totalTaxAmount\uff08\u7a0e\u989d\u5408\u8ba1\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(taxIncludedAmountInFigures) || taxIncludedAmountInFigures.equals("null")) {
                flag = 2;
                resultList.add("\u3010taxIncludedAmountInFigures\uff08\u4ef7\u7a0e\u5408\u8ba1\uff08\u5c0f\u5199\uff09\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty(dateOfIssue)) {
                flag = 2;
                resultList.add("\u3010dateOfIssue\uff08\u5f00\u7968\u65e5\u671f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceIsRedInvoice) || whetherInvoiceIsRedInvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceIsRedInvoice\uff08\u662f\u5426\u7ea2\u5b57\u53d1\u7968\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenChecked) || whetherInvoiceHasBeenChecked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenChecked\uff08\u662f\u5426\u5df2\u9a8c\u771f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenBooked) || whetherInvoiceHasBeenBooked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenBooked\uff08\u662f\u5426\u5df2\u5165\u8d26\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(unifiedSocialCreditCodeOfAccountingEntity) || unifiedSocialCreditCodeOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010unifiedSocialCreditCodeOfAccountingEntity\uff08\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfAccountingEntity) || nameOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010nameOfAccountingEntity\uff08\u4f1a\u8ba1\u5355\u4f4d\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInputVatHasBeenTransferredOut) || whetherInputVatHasBeenTransferredOut.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInputVatHasBeenTransferredOut\uff08\u662f\u5426\u8fdb\u9879\u7a0e\u989d\u8f6c\u51fa\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(amountOfTransferredOutInputVat) || amountOfTransferredOutInputVat.equals("null")) {
                flag = 2;
                resultList.add("\u3010amountOfTransferredOutInputVat\uff08\u8fdb\u9879\u7a0e\u989d\u8f6c\u51fa\u91d1\u989d\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceUsageHasBeenConfirmed) || whetherInvoiceUsageHasBeenConfirmed.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceUsageHasBeenConfirmed\uff08\u662f\u5426\u786e\u8ba4\u7528\u9014\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (whetherInvoiceUsageHasBeenConfirmed.equals("true")) {
                String periodOfUsageConfirmation;
                String usageConfirmation = invSpclInvReceiver.getUsageConfirmation();
                if (!StringUtils.hasText(usageConfirmation) || usageConfirmation.equals("null")) {
                    flag = 2;
                    resultList.add("usageConfirmation\uff08\u786e\u8ba4\u7528\u9014\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText(periodOfUsageConfirmation = invSpclInvReceiver.getPeriodOfUsageConfirmation()) || periodOfUsageConfirmation.equals("null")) {
                    flag = 2;
                    resultList.add("periodOfUsageConfirmation\uff08\u7528\u9014\u786e\u8ba4\u6240\u5c5e\u671f\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!CollectionUtils.isEmpty(accountList) && (stringBuilder = AccountDataManageUtil.checkAccountData(accountList)).length() > 0) {
                resultList.add(stringBuilder.toString());
                flag = 2;
            }
            if (flag == 2) {
                throw new ValidateException("\u6570\u7535\u7968(\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968)\u5fc5\u586b\u9879\u68c0\u67e5\u672a\u901a\u8fc7: " + JSON.toJSONString(resultList));
            }
        }
        invSpclReceiverVO.setUniquecode(invSpclInvReceiver.getUniqueCodeOfInvoice());
        invSpclReceiverVO.setUnitcode(unitcode);
        invSpclReceiverVO.setContractnumber(invSpclInvReceiver.getContractNumber());
        invSpclReceiverVO.setMatchingstate(invSpclInvReceiver.getMatchingStateBetweenBusinessDocumentsAndVatEInvoice());
        invSpclReceiverVO.setEamdprctmethods(invSpclInvReceiver.getDepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets());
        invSpclReceiverVO.setRedinvoice(whetherInvoiceIsRedInvoice);
        invSpclReceiverVO.setBeenchecked(whetherInvoiceHasBeenChecked);
        invSpclReceiverVO.setBeenconfirmed(whetherInvoiceUsageHasBeenConfirmed);
        invSpclReceiverVO.setUsageconfirmation(invSpclInvReceiver.getUsageConfirmation());
        String period = invSpclInvReceiver.getPeriodOfUsageConfirmation();
        if (StringUtils.hasText(period)) {
            invSpclReceiverVO.setUsageconfperiod(Integer.valueOf(period.replace("-", "")));
        }
        invSpclReceiverVO.setBeenbooked(whetherInvoiceHasBeenBooked);
        invSpclReceiverVO.setBeenpaid(invSpclInvReceiver.getWhetherInvoiceHasBeenPaid());
        invSpclReceiverVO.setElecreceiptnumber(invSpclInvReceiver.getNumberOfBankElectronicReceipt());
        invSpclReceiverVO.setBeentransferredout(whetherInputVatHasBeenTransferredOut);
        invSpclReceiverVO.setInputtaxoutmoney(CommonUtils.stringToBigDecimal(amountOfTransferredOutInputVat));
        invSpclReceiverVO.setSocialcreditcode(invSpclInvReceiver.getUnifiedSocialCreditCodeOfAccountingEntity());
        invSpclReceiverVO.setAccountname(invSpclInvReceiver.getNameOfAccountingEntity());
        invSpclReceiverVO.setBeginaccrual(invSpclInvReceiver.getBeginningOfExpenditurePeriodUnderAccrualBasis());
        invSpclReceiverVO.setEndaccrual(invSpclInvReceiver.getEndOfExpenditurePeriodUnderAccrualBasis());
        invSpclReceiverVO.setBeencompleted(invSpclInvReceiver.getWhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted());
        invSpclReceiverVO.setBeginincometax(invSpclInvReceiver.getBeginningOfPreTaxDeductionYearOfIncomeTax());
        invSpclReceiverVO.setEndincometax(invSpclInvReceiver.getEndOfPreTaxDeductionYearOfIncomeTax());
        invSpclReceiverVO.setSecuritized(invSpclInvReceiver.getWhetherInvoiceHasBeenFactoredSoldOrSecuritized());
        invSpclReceiverVO.setRecnameofseller(nameOfSeller);
        invSpclReceiverVO.setRectaxpayerident(taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller);
        invSpclReceiverVO.setRectotalamountexcludingtax(CommonUtils.stringToBigDecimal(totalAmountExcludingTax));
        invSpclReceiverVO.setRectotaltaxamount(CommonUtils.stringToBigDecimal(totalTaxAmount));
        invSpclReceiverVO.setRectaxincludedamountinfigures(CommonUtils.stringToBigDecimal(taxIncludedAmountInFigures));
        invSpclReceiverVO.setRecdateofissue(dateOfIssue);
        if (!CollectionUtils.isEmpty(accountList)) {
            List<ReceiverAccountBaseDO> detailList = AccountDataManageUtil.setAccountData(accountList);
            invSpclReceiverVO.setAccountList(detailList);
        }
        return true;
    }

    private void bill(InvSpclIssuer invSpclIssuer, InvSpclReceiverVO invSpclReceiverVO) {
        invSpclReceiverVO.setInvoicetype(invSpclIssuer.getTypeOfInvoice());
        invSpclReceiverVO.setUniquecode(invSpclIssuer.getUniqueCodeOfInvoice());
        invSpclReceiverVO.setLocations(invSpclIssuer.getLocationOfInvoice());
        invSpclReceiverVO.setInvoicecode(invSpclIssuer.getCodeOfInvoice());
        invSpclReceiverVO.setInvoicenumber(invSpclIssuer.getNumberOfInvoice());
        invSpclReceiverVO.setIssuedate(ObjectUtils.isEmpty(invSpclIssuer.getDateOfIssue()) ? null : invSpclIssuer.getDateOfIssue());
        invSpclReceiverVO.setIdentifycode(invSpclIssuer.getIdentifyingCode());
        invSpclReceiverVO.setSpecialinvoicetype(invSpclIssuer.getSpecialInvoiceType());
        invSpclReceiverVO.setInvoicemachine(invSpclIssuer.getNumberOfInvoiceMachine());
        invSpclReceiverVO.setInvoiceissuingsign(invSpclIssuer.getInvoiceIssuingSign());
        invSpclReceiverVO.setPurchasername(invSpclIssuer.getNameOfPurchaser());
        invSpclReceiverVO.setPurtaxpayeridentification(invSpclIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser());
        invSpclReceiverVO.setPurcapn(invSpclIssuer.getAddressPhoneNumberOfPurchaser());
        invSpclReceiverVO.setPurdepositban(invSpclIssuer.getDepositBankAndAccountNumberOfPurchaser());
        invSpclReceiverVO.setSecuritycode(invSpclIssuer.getSecurityCode());
        invSpclReceiverVO.setTotalamount(CommonUtils.stringToBigDecimal(invSpclIssuer.getTotalAmountExcludingTax()));
        invSpclReceiverVO.setTotaltaxamount(CommonUtils.stringToBigDecimal(invSpclIssuer.getTotalTaxAmount()));
        invSpclReceiverVO.setTaxpriceup(invSpclIssuer.getTaxIncludedAmountInWords());
        invSpclReceiverVO.setTaxpricelow(CommonUtils.stringToBigDecimal(invSpclIssuer.getTaxIncludedAmountInFigures()));
        invSpclReceiverVO.setSellername(invSpclIssuer.getNameOfSeller());
        invSpclReceiverVO.setSeltaxpayeridentification(invSpclIssuer.getTaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller());
        invSpclReceiverVO.setSelcapn(invSpclIssuer.getAddressPhoneNumberOfSeller());
        invSpclReceiverVO.setSeldepositban(invSpclIssuer.getDepositBankAndAccountNumberOfSeller());
        invSpclReceiverVO.setRemarks(invSpclIssuer.getRemarks());
        invSpclReceiverVO.setPayee(invSpclIssuer.getPayee());
        invSpclReceiverVO.setReviewer(invSpclIssuer.getReviewer());
        invSpclReceiverVO.setIssuer(invSpclIssuer.getIssuer());
        String begin = invSpclIssuer.getBeginningOfIncomePeriodUnderAccrualBasis();
        invSpclReceiverVO.setBeginacc(StringUtils.hasText(begin) ? Integer.valueOf(begin.replace("-", "")) : null);
        String end = invSpclIssuer.getEndOfIncomePeriodUnderAccrualBasis();
        invSpclReceiverVO.setEndacc(StringUtils.hasText(end) ? Integer.valueOf(end.replace("-", "")) : null);
        invSpclReceiverVO.setOriginalinvoicecode(invSpclIssuer.getCodeOfOriginalInvoice());
        invSpclReceiverVO.setOriginalinvoicenum(invSpclIssuer.getNumberOfOriginalInvoice());
        invSpclReceiverVO.setRushredreason(invSpclIssuer.getReasonOfRushRed());
        List<InformationOfTaxableGoodsOrServicesDetailItemsTuple> list = invSpclIssuer.getInformationOfTaxableGoodsOrServicesDetailItemsTuple();
        if (!CollectionUtils.isEmpty(list)) {
            List<InvSpclRIDetailDO> collect = list.stream().map(item -> DataUtils.getDetail(item, new TypeReference<InvSpclRIDetailDO>(this){})).collect(Collectors.toList());
            invSpclReceiverVO.setIssuerDetailList(collect);
        }
    }
}

