/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverAccountBaseDO;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.ntrevgpm.issuerDetail.NtrevGpmRIDetailDO;
import com.jiuqi.accds.feign.domain.vo.NtrevGpmReceiverVO;
import com.jiuqi.accds.feign.issuerentity.ntrev.Details;
import com.jiuqi.accds.feign.issuerentity.ntrev.Einvoice_data;
import com.jiuqi.accds.feign.issuerentity.ntrev.Exec_agency_party;
import com.jiuqi.accds.feign.issuerentity.ntrev.Header;
import com.jiuqi.accds.feign.issuerentity.ntrev.Item;
import com.jiuqi.accds.feign.issuerentity.ntrev.Main;
import com.jiuqi.accds.feign.issuerentity.ntrev.NtrevGpmIssuer;
import com.jiuqi.accds.feign.issuerentity.ntrev.Payer_party;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.domain.entity.NtrevGpmReceiver;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.util.AccountDataManageUtil;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtrevHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NtrevHandle.class);

    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        UploadFileDO issuerFile = pair.getIssuer();
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        if (ObjectUtils.isEmpty(issuerFile) || CollectionUtils.isEmpty(receiverFiles)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String issXml = issuerFile.getContent();
        NtrevGpmIssuer ntrevGpmIssuer = CommonUtils.xbrlToObject("ntrev_gpm_issuer", issXml, new TypeReference<NtrevGpmIssuer>(this){});
        if (ObjectUtils.isEmpty(ntrevGpmIssuer)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String iss_einvoiceid = null;
        List<Header> header = ntrevGpmIssuer.getHeader();
        if (!CollectionUtils.isEmpty(header)) {
            iss_einvoiceid = header.get(0).getEinvoice_id();
        }
        for (UploadFileDO receiverFile : receiverFiles) {
            try {
                this.processReceiverFile(receiverFileParamsDTO, ntrevGpmIssuer, receiverFile, iss_einvoiceid);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u7535\u5b50\u975e\u7a0e\u6536\u5165\u4e00\u822c\u7f34\u6b3e\u4e66\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                throw new ValidateException("\u5904\u7406\u7535\u5b50\u975e\u7a0e\u6536\u5165\u4e00\u822c\u7f34\u6b3e\u4e66\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private void processReceiverFile(ReceiverFileParamsDTO receiverFileParamsDTO, NtrevGpmIssuer ntrevGpmIssuer, UploadFileDO receiverFile, String iss_einvoiceid) {
        boolean checkStatus;
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        String receiverXml = receiverFile.getContent();
        NtrevGpmReceiver ntrevGpmReceiver = CommonUtils.xbrlToObject("ntrev_gpm_receiver", receiverXml, new TypeReference<NtrevGpmReceiver>(this){});
        if (ObjectUtils.isEmpty(ntrevGpmReceiver)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        NtrevGpmReceiverVO ntrevGpmReceiverVO = new NtrevGpmReceiverVO();
        if (!ObjectUtils.isEmpty(iss_einvoiceid)) {
            ntrevGpmReceiverVO.setEinvoiceid(iss_einvoiceid);
        }
        String rec_einvoiceId = ntrevGpmReceiver.getEinvoice_id();
        if (ObjectUtils.isEmpty(iss_einvoiceid) || ObjectUtils.isEmpty(rec_einvoiceId) || !iss_einvoiceid.equals(rec_einvoiceId)) {
            throw new ValidateException("\u3010\u7535\u5b50\u975e\u7a0e\u6536\u5165\u4e00\u822c\u7f34\u6b3e\u4e66\u7535\u5b50\u51ed\u8bc1\u4e0e\u751f\u6210\u7684\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u552f\u4e00\u6807\u8bc6 einvoice_id\uff08\u7535\u5b50\u7f34\u6b3e\u4e66\u6807\u8bc6\uff09\u4e0d\u4e00\u81f4,\u8bf7\u6838\u67e5issuer.xml\u548creceiver.xml\u3011");
        }
        String unifiedSocialCreditCode = ntrevGpmReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        if (!unioncode.equals(unifiedSocialCreditCode) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u7535\u5b50\u975e\u7a0e\u6536\u5165\u4e00\u822c\u7f34\u6b3e\u4e66\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u51ed\u8bc1\u6587\u4ef6\uff1a" + ntrevGpmReceiver.getUnifiedSocialCreditCodeOfAccountingEntity() + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        this.bill(ntrevGpmIssuer, ntrevGpmReceiverVO);
        this.account(unitcode, isCheckNull, ntrevGpmReceiver, ntrevGpmReceiverVO, iss_einvoiceid);
        if (isCheckNull && !(checkStatus = this.checkUniformity(ntrevGpmReceiverVO))) {
            throw new ValidateException("\u5f00\u5177\u65b9\u63a5\u6536\u65b9\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u672a\u901a\u8fc7");
        }
    }

    private boolean checkUniformity(NtrevGpmReceiverVO ntrevGpmReceiverVO) {
        if (!Objects.equals(ntrevGpmReceiverVO.getBilldate(), ntrevGpmReceiverVO.getRecbilldate())) {
            return false;
        }
        return Objects.equals(ntrevGpmReceiverVO.getPaidamt(), ntrevGpmReceiverVO.getRecpaidamt());
    }

    private boolean account(String unitcode, boolean isCheckNull, NtrevGpmReceiver ntrevGpmReceiver, NtrevGpmReceiverVO ntrevGpmReceiverVO, String iss_einvoiceid) {
        ArrayList<String> resultList = new ArrayList<String>();
        String whetherInvoiceIsRedInvoice = ntrevGpmReceiver.getWhetherInvoiceIsRedInvoice();
        String whetherInvoiceHasBeenChecked = ntrevGpmReceiver.getWhetherInvoiceHasBeenChecked();
        String whetherInvoiceHasBeenBooked = ntrevGpmReceiver.getWhetherInvoiceHasBeenBooked();
        String unifiedSocialCreditCodeOfAccountingEntity = ntrevGpmReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        String nameOfAccountingEntity = ntrevGpmReceiver.getNameOfAccountingEntity();
        List<InformationOfAccountingDocumentsTuple> accountList = ntrevGpmReceiver.getInformationOfAccountingDocumentsTuple();
        Date bill_date = ntrevGpmReceiver.getBill_date();
        String paid_amt = ntrevGpmReceiver.getPaid_amt();
        if (isCheckNull) {
            StringBuilder stringBuilder;
            int flag = 0;
            if (!StringUtils.hasText(iss_einvoiceid) || iss_einvoiceid.equals("null")) {
                flag = 2;
                resultList.add("\u3010einvoice_id\uff08\u7535\u5b50\u7f34\u6b3e\u4e66\u6807\u8bc6\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty(bill_date)) {
                flag = 2;
                resultList.add("\u3010bill_date\uff08\u5f00\u7968\u65e5\u671f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(paid_amt) || paid_amt.equals("null")) {
                flag = 2;
                resultList.add("\u3010paid_amt\uff08\u7f34\u6b3e\u91d1\u989d\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceIsRedInvoice) || whetherInvoiceIsRedInvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceIsRedInvoice\uff08\u662f\u5426\u7ea2\u5b57\u53d1\u7968\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenChecked) || whetherInvoiceHasBeenChecked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenChecked\uff08\u662f\u5426\u5df2\u9a8c\u771f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenBooked) || whetherInvoiceHasBeenBooked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenBooked\uff08\u662f\u5426\u5df2\u5165\u8d26\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(unifiedSocialCreditCodeOfAccountingEntity) || unifiedSocialCreditCodeOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010unifiedSocialCreditCodeOfAccountingEntity\uff08\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfAccountingEntity) || nameOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010nameOfAccountingEntity\uff08\u4f1a\u8ba1\u5355\u4f4d\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty(accountList) && (stringBuilder = AccountDataManageUtil.checkAccountData(accountList)).length() > 0) {
                resultList.add(stringBuilder.toString());
                flag = 2;
            }
            if (flag == 2) {
                throw new ValidateException("\u7535\u5b50\u975e\u7a0e\u6536\u5165\u4e00\u822c\u7f34\u6b3e\u4e66\u5fc5\u586b\u9879\u68c0\u67e5\u672a\u901a\u8fc7: " + JSON.toJSONString(resultList));
            }
        }
        ntrevGpmReceiverVO.setEinvoiceid(iss_einvoiceid);
        ntrevGpmReceiverVO.setUnitcode(unitcode);
        ntrevGpmReceiverVO.setRedinvoice(whetherInvoiceIsRedInvoice);
        ntrevGpmReceiverVO.setBeenchecked(whetherInvoiceHasBeenChecked);
        ntrevGpmReceiverVO.setBeenbooked(whetherInvoiceHasBeenBooked);
        ntrevGpmReceiverVO.setSocialcreditcode(unifiedSocialCreditCodeOfAccountingEntity);
        ntrevGpmReceiverVO.setAccountname(nameOfAccountingEntity);
        ntrevGpmReceiverVO.setRecbilldate(bill_date);
        ntrevGpmReceiverVO.setRecpaidamt(CommonUtils.stringToBigDecimal(paid_amt));
        if (!CollectionUtils.isEmpty(accountList)) {
            List<ReceiverAccountBaseDO> detailList = AccountDataManageUtil.setAccountData(accountList);
            ntrevGpmReceiverVO.setAccountList(detailList);
        }
        return true;
    }

    private void bill(NtrevGpmIssuer ntrevGpmIssuer, NtrevGpmReceiverVO ntrevGpmIssuerVO) {
        List<Einvoice_data> einvoiceData = ntrevGpmIssuer.getEinvoice_data();
        if (!CollectionUtils.isEmpty(einvoiceData)) {
            List<Item> items;
            List<Details> details;
            List<Main> main = einvoiceData.get(0).getMain();
            if (!CollectionUtils.isEmpty(main)) {
                List<Payer_party> payerParty;
                ntrevGpmIssuerVO.setEinvoicename(main.get(0).getEinvoice_name());
                ntrevGpmIssuerVO.setEinvoicecode(main.get(0).getEinvoice_code());
                ntrevGpmIssuerVO.setNontaxpayno(main.get(0).getNon_tax_pay_no());
                ntrevGpmIssuerVO.setNontaxpaycode(main.get(0).getNon_tax_pay_code());
                ntrevGpmIssuerVO.setRandomnumber(main.get(0).getRandom_number());
                ntrevGpmIssuerVO.setBilldate(ObjectUtils.isEmpty(main.get(0).getBill_date()) ? null : main.get(0).getBill_date());
                ntrevGpmIssuerVO.setBilltime(main.get(0).getBill_time());
                ntrevGpmIssuerVO.setPaidamt(CommonUtils.stringToBigDecimal(main.get(0).getPaid_amt()));
                List<Exec_agency_party> execAgencyParty = main.get(0).getExec_agency_party();
                if (!CollectionUtils.isEmpty(execAgencyParty)) {
                    ntrevGpmIssuerVO.setExecagencycode(execAgencyParty.get(0).getExec_agency_code());
                    ntrevGpmIssuerVO.setExecagencyname(execAgencyParty.get(0).getExec_agency_name());
                    ntrevGpmIssuerVO.setPayeeacctname(execAgencyParty.get(0).getPayee_acct_name());
                    ntrevGpmIssuerVO.setPayeeacctno(execAgencyParty.get(0).getPayee_acct_no());
                    ntrevGpmIssuerVO.setPayeeacctbankname(execAgencyParty.get(0).getPayee_acct_bank_name());
                }
                if (!CollectionUtils.isEmpty(payerParty = main.get(0).getPayer_party())) {
                    ntrevGpmIssuerVO.setPayername(payerParty.get(0).getPayer_name());
                    ntrevGpmIssuerVO.setPayeraccno(payerParty.get(0).getPayer_acc_no());
                    ntrevGpmIssuerVO.setPayeropenbank(payerParty.get(0).getPayer_open_bank());
                }
                ntrevGpmIssuerVO.setAuthor(main.get(0).getAuthor());
                ntrevGpmIssuerVO.setChecker(main.get(0).getChecker());
                ntrevGpmIssuerVO.setRemark(main.get(0).getRemark());
            }
            if (!CollectionUtils.isEmpty(details = einvoiceData.get(0).getDetails()) && !CollectionUtils.isEmpty(items = details.get(0).getItem())) {
                List<NtrevGpmRIDetailDO> detailList = items.stream().map(item -> {
                    NtrevGpmRIDetailDO ntrevGpmIssuerDetailDO = new NtrevGpmRIDetailDO();
                    ntrevGpmIssuerDetailDO.setNontaxcode(item.getNon_tax_code());
                    ntrevGpmIssuerDetailDO.setNontaxname(item.getNon_tax_name());
                    ntrevGpmIssuerDetailDO.setPaynumber(item.getPay_number());
                    ntrevGpmIssuerDetailDO.setChargestandunit(item.getCharge_stand_unit());
                    ntrevGpmIssuerDetailDO.setChargestand(item.getCharge_stand());
                    ntrevGpmIssuerDetailDO.setPaiddetailamt(CommonUtils.stringToBigDecimal(item.getPaid_detail_amt()));
                    return ntrevGpmIssuerDetailDO;
                }).collect(Collectors.toList());
                ntrevGpmIssuerVO.setIssuerDetailList(detailList);
            }
        }
    }
}

