/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.handle;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.TypeReference;
import com.jiuqi.accds.feign.domain.ReceiverAccountBaseDO;
import com.jiuqi.accds.feign.domain.ReceiverFileParamsDTO;
import com.jiuqi.accds.feign.domain.UploadFileDO;
import com.jiuqi.accds.feign.domain.vo.RaiReceiverVO;
import com.jiuqi.accds.feign.issuerentity.rai.RaiIssuer;
import com.jiuqi.accds.feign.util.VerifyPair;
import com.jiuqi.gov.dzpz.validategui.constant.CommonConstant;
import com.jiuqi.gov.dzpz.validategui.domain.entity.RaiReceiver;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.exception.ValidateException;
import com.jiuqi.gov.dzpz.validategui.handle.EinvOrdHandle;
import com.jiuqi.gov.dzpz.validategui.util.AccountDataManageUtil;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import com.jiuqi.gov.dzpz.validategui.util.StringUtils;
import com.jiuqi.va.domain.user.UserLoginDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaiHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RaiHandle.class);

    public void handleFile(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        if (pair.isEmpty()) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        UploadFileDO issuerFile = pair.getIssuer();
        String issXml = issuerFile.getContent();
        if (this.isNewRailwayInvoiceFormat(issXml)) {
            this.handleNewFormatRailwayInvoice(receiverFileParamsDTO, pair);
        } else {
            this.handleTraditionalRailwayInvoice(receiverFileParamsDTO, pair, issXml);
        }
    }

    private boolean isNewRailwayInvoiceFormat(String xmlContent) {
        int endOfDeclaration;
        if (!StringUtils.hasText(xmlContent)) {
            return false;
        }
        String trimmedContent = xmlContent.trim();
        if (trimmedContent.startsWith("<?xml") && (endOfDeclaration = trimmedContent.indexOf("?>")) != -1) {
            trimmedContent = trimmedContent.substring(endOfDeclaration + 2).trim();
        }
        return trimmedContent.startsWith("<EInvoice");
    }

    private void handleNewFormatRailwayInvoice(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair) throws Exception {
        log.info("\u68c0\u6d4b\u5230\u65b0\u683c\u5f0f\u7684\u94c1\u8def\u5ba2\u7968\uff0c\u4f7f\u7528\u6570\u7535\u7968\u5904\u7406\u903b\u8f91");
        EinvOrdHandle einvOrdHandle = new EinvOrdHandle();
        einvOrdHandle.handleFile(receiverFileParamsDTO, pair);
    }

    private void handleTraditionalRailwayInvoice(ReceiverFileParamsDTO receiverFileParamsDTO, VerifyPair<UploadFileDO, UploadFileDO> pair, String issXml) {
        log.info("\u68c0\u6d4b\u5230\u4f20\u7edf\u683c\u5f0f\u7684\u94c1\u8def\u5ba2\u7968\uff0c\u4f7f\u7528\u539f\u6709XBRL\u5904\u7406\u903b\u8f91");
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String fileId = receiverFileParamsDTO.getFileId();
        RaiIssuer raiIssuer = CommonUtils.xbrlToObject("rai_issuer", issXml, new TypeReference<RaiIssuer>(this){});
        if (ObjectUtils.isEmpty(raiIssuer)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String iss_elecnumber = raiIssuer.getElectronicInvoiceRailwayETicketNumber();
        List<UploadFileDO> receiverFiles = pair.getAllReceivers();
        for (UploadFileDO receiverFile : receiverFiles) {
            try {
                this.processReceiverFile(receiverFileParamsDTO, raiIssuer, receiverFile, iss_elecnumber);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u94c1\u8def\u7535\u5b50\u5ba2\u7968\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                throw new ValidateException("\u5904\u7406\u94c1\u8def\u7535\u5b50\u5ba2\u7968\u63a5\u6536\u65b9\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private void processReceiverFile(ReceiverFileParamsDTO receiverFileParamsDTO, RaiIssuer raiIssuer, UploadFileDO receiverFile, String iss_elecnumber) {
        boolean checkStatus;
        UserLoginDTO user = receiverFileParamsDTO.getUser();
        String unitcode = receiverFileParamsDTO.getUnitcode();
        String unioncode = receiverFileParamsDTO.getUnioncode();
        String checkOrgFlag = receiverFileParamsDTO.getCheckOrgFlag();
        boolean isCheckNull = receiverFileParamsDTO.isCheckNull();
        String fileId = receiverFileParamsDTO.getFileId();
        String receiverXml = receiverFile.getContent();
        RaiReceiver raiReceiver = CommonUtils.xbrlToObject("rai_receiver", receiverXml, new TypeReference<RaiReceiver>(this){});
        if (ObjectUtils.isEmpty(raiReceiver)) {
            throw new ValidateException("\u5de5\u5177\u5305\u89e3\u6790xml\u6587\u4ef6\u629b\u51fa\u5f02\u5e38\uff0c\u672a\u63d0\u53d6\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u68c0\u67e5xml\u6587\u4ef6");
        }
        String rec_elecnumber = raiReceiver.getElectronicinvoicerailwayeticketnumber();
        if (ObjectUtils.isEmpty(iss_elecnumber) || ObjectUtils.isEmpty(rec_elecnumber) || !iss_elecnumber.equals(rec_elecnumber)) {
            throw new ValidateException("\u3010\u6570\u7535\u53d1\u7968\uff08\u94c1\u8def\u7535\u5b50\u5ba2\u7968\uff09\u7535\u5b50\u51ed\u8bc1\u4e0e\u751f\u6210\u7684\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u552f\u4e00\u6807\u8bc6 electronicinvoicerailwayeticketnumber\uff08\u7535\u5b50\u53d1\u7968\u94c1\u8defE\u7968\u53f7\uff09\u4e0d\u4e00\u81f4,\u8bf7\u6838\u67e5issuer.xml\u548creceiver.xml\u3011");
        }
        String unifiedSocialCreditCodeOfPurchaser = raiIssuer.getUnifiedSocialCreditCodeOfPurchaser();
        if (!unioncode.equals(unifiedSocialCreditCodeOfPurchaser) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u6570\u7535\u7968(\u94c1\u8def\u7535\u5b50\u5ba2\u7968)\u8d2d\u4e70\u65b9\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u51ed\u8bc1\u6587\u4ef6\uff1a" + unifiedSocialCreditCodeOfPurchaser + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        String unifiedSocialCreditCode = raiReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        if (!unioncode.equals(raiReceiver.getUnifiedSocialCreditCodeOfAccountingEntity()) && StringUtils.hasText(checkOrgFlag) && CommonConstant.TRUE.equals(checkOrgFlag)) {
            throw new ValidateException("\u3010\u51ed\u8bc1\u6587\u4ef6\u3011\u3010\u6570\u7535\u7968(\u94c1\u8def\u7535\u5b50\u5ba2\u7968)\u4f1a\u8ba1\u5165\u8d26\u4fe1\u606f\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6240\u5c5e\u673a\u6784\u7684\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u3011\u51ed\u8bc1\u6587\u4ef6\uff1a" + unifiedSocialCreditCode + ",\u673a\u6784\u7ef4\u62a4\uff1a" + unioncode);
        }
        if (isCheckNull && !(checkStatus = this.checkUniformity(raiIssuer, raiReceiver))) {
            throw new ValidateException("\u5f00\u5177\u65b9\u63a5\u6536\u65b9\u6570\u636e\u4e00\u81f4\u6027\u68c0\u67e5\u672a\u901a\u8fc7");
        }
        RaiReceiverVO raiReceiverVO = new RaiReceiverVO();
        this.bill(raiIssuer, iss_elecnumber, raiReceiverVO);
        this.account(user, unitcode, isCheckNull, raiReceiver, iss_elecnumber, rec_elecnumber, raiReceiverVO, fileId);
    }

    private boolean checkUniformity(RaiIssuer raiIssuer, RaiReceiver raiReceiver) {
        if (!Objects.equals(raiIssuer.getDateOfIssue(), raiReceiver.getDateOfIssue())) {
            return false;
        }
        if (!Objects.equals(raiIssuer.getTotalAmountExcludingTax(), raiReceiver.getTotalAmountExcludingTax())) {
            return false;
        }
        if (!Objects.equals(raiIssuer.getTaxRate(), raiReceiver.getTaxRate())) {
            return false;
        }
        return Objects.equals(raiIssuer.getTaxAmount(), raiReceiver.getTaxAmount());
    }

    private boolean account(UserLoginDTO user, String unitcode, boolean isCheckNull, RaiReceiver raiReceiver, String iss_elecnumber, String rec_elecnumber, RaiReceiverVO raiReceiverVO, String fileId) {
        ArrayList<String> resultList = new ArrayList<String>();
        String whetherInvoiceIsRedInvoice = raiReceiver.getWhetherInvoiceIsRedInvoice();
        String whetherInvoiceHasBeenBooked = raiReceiver.getWhetherInvoiceHasBeenBooked();
        String whetherInvoiceHasBeenDeducted = raiReceiver.getWhetherInvoiceHasBeenDeducted();
        String taxPeriod = raiReceiver.getTaxPeriodOfInvoiceDeduction();
        String unifiedSocialCreditCodeOfAccountingEntity = raiReceiver.getUnifiedSocialCreditCodeOfAccountingEntity();
        String nameOfAccountingEntity = raiReceiver.getNameOfAccountingEntity();
        List<InformationOfAccountingDocumentsTuple> list = raiReceiver.getInformationOfAccountingDocumentsTuple();
        Date dateOfIssue = raiReceiver.getDateOfIssue();
        String totalAmountExcludingTax = raiReceiver.getTotalAmountExcludingTax();
        String taxRate = raiReceiver.getTaxRate();
        String taxAmount = raiReceiver.getTaxAmount();
        if (isCheckNull) {
            StringBuilder stringBuilder;
            int flag = 0;
            if (!StringUtils.hasText(rec_elecnumber) || rec_elecnumber.equals("null")) {
                flag = 2;
                resultList.add("\u3010electronicinvoicerailwayeticketnumber\uff08\u7535\u5b50\u53d1\u7968\u94c1\u8defE\u7968\u53f7\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty(dateOfIssue)) {
                flag = 2;
                resultList.add("\u3010dateOfIssue\uff08\u5f00\u7968\u65e5\u671f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(totalAmountExcludingTax) || totalAmountExcludingTax.equals("null")) {
                flag = 2;
                resultList.add("\u3010totalAmountExcludingTax\uff08\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(taxRate) || taxRate.equals("null")) {
                flag = 2;
                resultList.add("\u3010taxRate\uff08\u7a0e\u7387\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(taxAmount) || taxAmount.equals("null")) {
                flag = 2;
                resultList.add("\u3010taxAmount\uff08\u7a0e\u989d\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceIsRedInvoice) || whetherInvoiceIsRedInvoice.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceIsRedInvoice\uff08\u662f\u5426\u7ea2\u5b57\u53d1\u7968\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenBooked) || whetherInvoiceHasBeenBooked.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenBooked\uff08\u662f\u5426\u5df2\u5165\u8d26\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(whetherInvoiceHasBeenDeducted) || whetherInvoiceHasBeenDeducted.equals("null")) {
                flag = 2;
                resultList.add("\u3010whetherInvoiceHasBeenDeducted\uff08\u662f\u5426\u5df2\u62b5\u6263\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(taxPeriod) || taxPeriod.equals("null")) {
                flag = 2;
                resultList.add("\u3010taxPeriod\uff08\u53d1\u7968\u6263\u7a0e\u671f\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(unifiedSocialCreditCodeOfAccountingEntity) || unifiedSocialCreditCodeOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010unifiedSocialCreditCodeOfAccountingEntity\uff08\u7edf\u4e00\u4f1a\u8ba1\u4e3b\u4f53\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText(nameOfAccountingEntity) || nameOfAccountingEntity.equals("null")) {
                flag = 2;
                resultList.add("\u3010nameOfAccountingEntity\uff08\u4f1a\u8ba1\u5355\u4f4d\u540d\u79f0\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty(list) && (stringBuilder = AccountDataManageUtil.checkAccountData(list)).length() > 0) {
                resultList.add(stringBuilder.toString());
                flag = 2;
            }
            if (flag == 2) {
                throw new ValidateException("\u6570\u7535\u7968(\u94c1\u8def\u7535\u5b50\u5ba2\u7968)\u5fc5\u586b\u9879\u68c0\u67e5\u672a\u901a\u8fc7\uff1a" + JSON.toJSONString(resultList));
            }
        }
        raiReceiverVO.setElecticketnumber(rec_elecnumber);
        raiReceiverVO.setRedinvoice(whetherInvoiceIsRedInvoice);
        raiReceiverVO.setBeenbooked(whetherInvoiceHasBeenBooked);
        raiReceiverVO.setBeendeducted(whetherInvoiceHasBeenDeducted);
        if (StringUtils.hasText(taxPeriod)) {
            raiReceiverVO.setTaxperiod(Integer.valueOf(taxPeriod.replace("-", "")));
        }
        raiReceiverVO.setSocialcreditcode(unifiedSocialCreditCodeOfAccountingEntity);
        raiReceiverVO.setAccountname(nameOfAccountingEntity);
        raiReceiverVO.setUnitcode(unitcode);
        if (!CollectionUtils.isEmpty(list)) {
            List<ReceiverAccountBaseDO> detailList = AccountDataManageUtil.setAccountData(list);
            raiReceiverVO.setAccountList(detailList);
        }
        raiReceiverVO.setRecdateofissue(dateOfIssue);
        raiReceiverVO.setRectotalamountexcludingtax(CommonUtils.stringToBigDecimal(totalAmountExcludingTax));
        raiReceiverVO.setRectaxrate(taxRate);
        raiReceiverVO.setRectaxamount(CommonUtils.stringToBigDecimal(taxAmount));
        return true;
    }

    private void bill(RaiIssuer raiIssuer, String iss_elecnumber, RaiReceiverVO raiReceiverVO) {
        raiReceiverVO.setVouchertype(raiIssuer.getTypeOfVoucher());
        raiReceiverVO.setElecticketnumber(iss_elecnumber);
        raiReceiverVO.setIssuedate(ObjectUtils.isEmpty(raiIssuer.getDateOfIssue()) ? null : raiIssuer.getDateOfIssue());
        raiReceiverVO.setIssueparty(raiIssuer.getIssueParty());
        raiReceiverVO.setIssuepartycode(raiIssuer.getIssuePartyCode());
        raiReceiverVO.setTypeofbusiness(raiIssuer.getTypeOfBusiness());
        raiReceiverVO.setDeparturestation(raiIssuer.getDepartureStation());
        raiReceiverVO.setDeparturephonics(raiIssuer.getPhonicsOfDepartureStation());
        raiReceiverVO.setDestinationstation(raiIssuer.getDestinationStation());
        raiReceiverVO.setDestinationphonics(raiIssuer.getPhonicsOfDestinationStation());
        raiReceiverVO.setTrainnumber(raiIssuer.getTrainNumber());
        raiReceiverVO.setTraveldate(ObjectUtils.isEmpty(raiIssuer.getTravelDate()) ? null : raiIssuer.getTravelDate());
        raiReceiverVO.setDeparturetime(raiIssuer.getDepartureTime());
        raiReceiverVO.setTickettype(raiIssuer.getTypeOfRailwayTicket());
        raiReceiverVO.setAirconditioning(raiIssuer.getAirConditioningCharacteristics());
        raiReceiverVO.setSeatlevel(raiIssuer.getSeatLevel());
        raiReceiverVO.setCarriage(raiIssuer.getCarriage());
        raiReceiverVO.setSeat(raiIssuer.getSeat());
        raiReceiverVO.setDiscountmark(raiIssuer.getDiscountMark());
        raiReceiverVO.setFare(CommonUtils.stringToBigDecimal(raiIssuer.getFare()));
        raiReceiverVO.setAmountrefunded(CommonUtils.stringToBigDecimal(raiIssuer.getAmountRefunded()));
        raiReceiverVO.setOriginalfare(CommonUtils.stringToBigDecimal(raiIssuer.getFareOfOriginalRailwayTicket()));
        raiReceiverVO.setOriginaldeparture(raiIssuer.getDepartureStationOfOriginalRailwayTicket());
        raiReceiverVO.setOriginaldestination(raiIssuer.getDestinationStationOfOriginalRailwayTicket());
        raiReceiverVO.setEticketnumber(raiIssuer.geteTicketNumber());
        raiReceiverVO.setIdnumber(raiIssuer.getIdNumber());
        raiReceiverVO.setName(raiIssuer.getName());
        raiReceiverVO.setTotalamountexctax(CommonUtils.stringToBigDecimal(raiIssuer.getTotalAmountExcludingTax()));
        raiReceiverVO.setTaxrate(raiIssuer.getTaxRate());
        raiReceiverVO.setTaxamount(CommonUtils.stringToBigDecimal(raiIssuer.getTaxAmount()));
        raiReceiverVO.setPurchasername(raiIssuer.getNameOfPurchaser());
        raiReceiverVO.setPurunifiedsocial(raiIssuer.getUnifiedSocialCreditCodeOfPurchaser());
        raiReceiverVO.setPurapn(raiIssuer.getAddressPhoneNumberOfPurchaser());
        raiReceiverVO.setPurdban(raiIssuer.getDepositBankAndAccountNumberOfPurchaser());
        raiReceiverVO.setSellername(raiIssuer.getNameOfSeller());
        raiReceiverVO.setSelunifiedsocial(raiIssuer.getUnifiedSocialCreditCodeOfSeller());
        raiReceiverVO.setSelapn(raiIssuer.getAddressPhoneNumberOfSeller());
        raiReceiverVO.setSeldpan(raiIssuer.getDepositBankAndAccountNumberOfSeller());
        raiReceiverVO.setOriginalnumber(raiIssuer.getNumberOfOriginalInvoice());
        raiReceiverVO.setRemarks(raiIssuer.getRemarks());
    }
}

