/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.json;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FlexibleDateDeserializer
implements ObjectReader<Date> {
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd", "yyyy-M-d", "yyyy/MM/dd", "yyyy/M/d"};
    private static final ThreadLocal<SimpleDateFormat[]> DATE_FORMATTERS = ThreadLocal.withInitial(() -> {
        SimpleDateFormat[] formatters = new SimpleDateFormat[DATE_FORMATS.length];
        for (int i = 0; i < DATE_FORMATS.length; ++i) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMATS[i]);
            sdf.setLenient(false);
            formatters[i] = sdf;
        }
        return formatters;
    });

    @Override
    public Date readObject(JSONReader reader, Type fieldType, Object fieldName, long features) {
        String dateStr = reader.readString();
        if (dateStr == null || dateStr.trim().isEmpty()) {
            return null;
        }
        SimpleDateFormat[] formatters = DATE_FORMATTERS.get();
        String trimmedDateStr = dateStr.trim();
        for (SimpleDateFormat formatter : formatters) {
            try {
                return formatter.parse(trimmedDateStr);
            }
            catch (ParseException parseException) {
            }
        }
        throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u65e5\u671f\u683c\u5f0f: " + dateStr + ", \u652f\u6301\u7684\u683c\u5f0f: yyyy-MM-dd, yyyy-M-d, yyyy/MM/dd, yyyy/M/d");
    }

    public static void clearThreadLocal() {
        DATE_FORMATTERS.remove();
    }
}

