/*
 * Decompiled with CFR 0.152.
 */
package com.jiuqi.gov.dzpz.validategui.util;

import com.jiuqi.accds.feign.domain.ReceiverAccountBaseDO;
import com.jiuqi.accds.feign.domain.ReceiverAccountDetailBaseDO;
import com.jiuqi.accds.feign.domain.atr.detail.AtrReceiverDetailDO;
import com.jiuqi.accds.feign.domain.bker.account.BkerReceiverAccountVO;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfAccountingDocumentsTuple;
import com.jiuqi.gov.dzpz.validategui.domain.entity.common.InformationOfDebitAndCreditEntryTuple;
import com.jiuqi.gov.dzpz.validategui.util.CommonUtils;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AccountDataManageUtil {
    public static List<ReceiverAccountBaseDO> setAccountData(List<InformationOfAccountingDocumentsTuple> list) {
        List<ReceiverAccountBaseDO> detailList = list.stream().map(item -> {
            BkerReceiverAccountVO detail = new BkerReceiverAccountVO();
            detail.setAccountnumber(item.getNumberOfAccountingDocuments());
            detail.setPostingdate(item.getPostingDate());
            String period = item.getAccountingPeriod();
            if (StringUtils.isNotBlank(period)) {
                detail.setAccountperiod(Integer.valueOf(period.replace("-", "")));
            }
            detail.setAccountsummary(item.getSummaryOfAccountingDocuments());
            List<ReceiverAccountDetailBaseDO> bkerDetailList = AccountDataManageUtil.setDetailList(item.getInformationOfDebitAndCreditEntryTuple());
            detail.setDetailList(bkerDetailList);
            return detail;
        }).collect(Collectors.toList());
        return detailList;
    }

    private static List<ReceiverAccountDetailBaseDO> setDetailList(List<InformationOfDebitAndCreditEntryTuple> list) {
        List detailList = null;
        if (!CollectionUtils.isEmpty(list)) {
            detailList = list.stream().map(item -> {
                AtrReceiverDetailDO detail = new AtrReceiverDetailDO();
                detail.setDebitorcredit(item.getDebitOrCredit());
                detail.setGeneralsubjectname(item.getNameOfGeneralLedgerSubject());
                detail.setSubsidiarysubjectname(item.getNameOfSubsidiaryLedgerSubject());
                detail.setRecordedamount(CommonUtils.stringToBigDecimal(item.getRecordedAmount()));
                return detail;
            }).collect(Collectors.toList());
        }
        return detailList;
    }

    public static StringBuilder checkAccountData(List<InformationOfAccountingDocumentsTuple> list) {
        StringBuilder stringBuilder = new StringBuilder();
        list.forEach(item -> {
            String period;
            Date postingDate;
            String numberOfAccountingDocuments = item.getNumberOfAccountingDocuments();
            if (StringUtils.isBlank(numberOfAccountingDocuments) || numberOfAccountingDocuments.equals("null")) {
                stringBuilder.append("numberOfAccountingDocuments\uff08\u4f1a\u8ba1\u51ed\u8bc1\u7f16\u53f7\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
            }
            if (ObjectUtils.isEmpty(postingDate = item.getPostingDate())) {
                stringBuilder.append("postingDate\uff08\u8bb0\u8d26\u65e5\u671f\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
            }
            if (StringUtils.isBlank(period = item.getAccountingPeriod()) || period.equals("null")) {
                stringBuilder.append("accountingPeriod\uff08\u4f1a\u8ba1\u671f\u95f4\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
            }
        });
        return stringBuilder;
    }
}

