/*
 * Decompiled with CFR 0.152.
 */
package com.pansoft.xbrl.xbrljson.reader.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.pansoft.xbrl.xbrljson.reader.XbrlReader;
import com.pansoft.xbrl.xbrljson.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class BaseXbrlReader
implements XbrlReader {
    private static Logger log = Logger.getLogger(BaseXbrlReader.class.toString());
    public static final HashSet<String> InvalidNodeSet = new HashSet();

    @Override
    public JSONObject readXbrlDataWithPath(String xbrlFilePath) throws DocumentException {
        Document document = null;
        JSONObject xbrlDataJsonObject = null;
        try {
            SAXReader saxReader = new SAXReader();
            document = saxReader.read(xbrlFilePath);
            xbrlDataJsonObject = this.readXbrlData(document);
        }
        catch (DocumentException e) {
            log.info(e.toString());
        }
        return xbrlDataJsonObject;
    }

    @Override
    public JSONObject readXbrlDataWithXml(String xmlValue) throws Exception {
        if (StringUtil.isBlank(xmlValue)) {
            return null;
        }
        Document document = null;
        JSONObject xbrlDataJsonObject = null;
        try {
            document = DocumentHelper.parseText(xmlValue);
            xbrlDataJsonObject = this.readXbrlData(document);
        }
        catch (DocumentException e) {
            log.info(e.toString());
        }
        return xbrlDataJsonObject;
    }

    public JSONObject readXbrlData(Document doc) {
        if (doc == null) {
            return null;
        }
        Element rootNode = doc.getRootElement();
        if (rootNode == null) {
            return null;
        }
        List<Element> itemList = rootNode.elements();
        if (itemList == null || itemList.size() == 0) {
            return null;
        }
        JSONObject dataObject = new JSONObject(true);
        String itemName = null;
        for (Element item : itemList) {
            itemName = item.getName();
            if (InvalidNodeSet.contains(itemName)) continue;
            this.processInstDataNode(item, dataObject);
        }
        return dataObject;
    }

    private void processInstDataNode(Element item, JSONObject parentObjectNode) {
        if (item == null || parentObjectNode == null) {
            return;
        }
        String nodeName = item.getNamespace().getPrefix() + ":" + item.getName();
        String nodeValue = item.getTextTrim();
        List<Element> childList = item.elements();
        if (childList != null && childList.size() > 0) {
            JSONArray compNode = (JSONArray)parentObjectNode.get(nodeName);
            if (compNode == null) {
                compNode = new JSONArray();
                parentObjectNode.put(nodeName, (Object)compNode);
            }
            JSONObject childNodeObject = new JSONObject(true);
            compNode.add(childNodeObject);
            for (Element child : childList) {
                this.processInstDataNode(child, childNodeObject);
            }
        } else {
            parentObjectNode.put(nodeName, (Object)nodeValue);
        }
    }

    static {
        InvalidNodeSet.add("schemaRef");
        InvalidNodeSet.add("context");
        InvalidNodeSet.add("unit");
    }
}

