/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.CellViewSkin;
import impl.org.controlsfx.spreadsheet.GridCellEditor;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewBehavior;
import impl.org.controlsfx.spreadsheet.GridVirtualFlow;
import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import impl.org.controlsfx.spreadsheet.HorizontalPicker;
import impl.org.controlsfx.spreadsheet.RectangleSelection;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import impl.org.controlsfx.spreadsheet.VerticalHeader;
import java.time.LocalDate;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.Screen;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridViewSkin
extends TableViewSkinBase<ObservableList<SpreadsheetCell>, ObservableList<SpreadsheetCell>, TableView<ObservableList<SpreadsheetCell>>, TableRow<ObservableList<SpreadsheetCell>>, TableColumn<ObservableList<SpreadsheetCell>, ?>> {
    public static final double DEFAULT_CELL_HEIGHT = 24.0;
    private static final double DATE_CELL_MIN_WIDTH = 200.0 - Screen.getPrimary().getDpi();
    final Map<GridRow, Set<CellView>> deportedCells = new HashMap<GridRow, Set<CellView>>();
    ObservableMap<Integer, Double> rowHeightMap = FXCollections.observableHashMap();
    private GridCellEditor gridCellEditor;
    protected final SpreadsheetHandle handle;
    protected SpreadsheetView spreadsheetView;
    protected VerticalHeader verticalHeader;
    protected HorizontalPicker horizontalPickers;
    private ObservableSet<Integer> currentlyFixedRow = FXCollections.observableSet(new HashSet());
    private final ObservableList<Integer> selectedRows = FXCollections.observableArrayList();
    private final ObservableList<Integer> selectedColumns = FXCollections.observableArrayList();
    private double fixedRowHeight = 0.0;
    BitSet hBarValue;
    BitSet rowToLayout;
    RectangleSelection rectangleSelection;
    double fixedColumnWidth;
    BooleanProperty lastRowLayout = new SimpleBooleanProperty(true);
    private GridViewBehavior behavior;
    private InvalidationListener rowToLayoutListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            GridViewSkin.this.rowToLayout = GridViewSkin.this.initRowToLayoutBitSet();
        }
    };
    private final InvalidationListener vbarValueListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable valueModel) {
            GridViewSkin.this.verticalScroll();
        }
    };
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends Integer> c) {
            GridViewSkin.this.hBarValue.clear();
            while (c.next()) {
                if (c.wasPermutated()) {
                    for (Integer n : c.getList()) {
                        GridViewSkin.this.rowToLayout.set(GridViewSkin.this.spreadsheetView.getFilteredRow(n), true);
                    }
                    continue;
                }
                block2: for (Integer n : c.getRemoved()) {
                    GridViewSkin.this.rowToLayout.set(GridViewSkin.this.spreadsheetView.getFilteredRow(n), false);
                    if (GridViewSkin.this.spreadsheetView.getGrid().getRows().size() <= n) continue;
                    List myRow = (List)GridViewSkin.this.spreadsheetView.getGrid().getRows().get(n);
                    for (SpreadsheetCell cell : myRow) {
                        if (GridViewSkin.this.spreadsheetView.getRowSpanFilter(cell) <= 1) continue;
                        GridViewSkin.this.rowToLayout.set(GridViewSkin.this.spreadsheetView.getFilteredRow(n), true);
                        continue block2;
                    }
                }
                for (Integer n : c.getAddedSubList()) {
                    GridViewSkin.this.rowToLayout.set(GridViewSkin.this.spreadsheetView.getFilteredRow(n), true);
                }
            }
            GridViewSkin.this.getFlow().requestLayout();
        }
    };
    private final SetChangeListener<? super Integer> currentlyFixedRowListener = new SetChangeListener<Integer>(){

        @Override
        public void onChanged(SetChangeListener.Change<? extends Integer> arg0) {
            GridViewSkin.this.computeFixedRowHeight();
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> c) {
            GridViewSkin.this.hBarValue.clear();
            GridViewSkin.this.getFlow().requestLayout();
        }
    };

    public GridViewSkin(final SpreadsheetHandle handle) {
        super(handle.getGridView());
        this.behavior = new GridViewBehavior(handle.getGridView());
        this.handle = handle;
        this.spreadsheetView = handle.getView();
        this.gridCellEditor = new GridCellEditor(handle);
        SpreadsheetGridView tableView = handle.getGridView();
        tableView.setRowFactory(new Callback<TableView<ObservableList<SpreadsheetCell>>, TableRow<ObservableList<SpreadsheetCell>>>(){

            @Override
            public TableRow<ObservableList<SpreadsheetCell>> call(TableView<ObservableList<SpreadsheetCell>> p) {
                return new GridRow(handle);
            }
        });
        this.getVirtualFlow().setCellFactory(param -> this.createCell());
        tableView.getStyleClass().add("cell-spreadsheet");
        this.getCurrentlyFixedRow().addListener(this.currentlyFixedRowListener);
        this.spreadsheetView.getFixedRows().addListener(this.fixedRowsListener);
        this.spreadsheetView.getFixedColumns().addListener(this.fixedColumnsListener);
        this.init();
        handle.getView().gridProperty().addListener(this.rowToLayoutListener);
        handle.getView().hiddenRowsProperty().addListener(this.rowToLayoutListener);
        handle.getView().hiddenColumnsProperty().addListener(this.rowToLayoutListener);
        this.hBarValue = new BitSet(this.getItemCount());
        this.rowToLayout = this.initRowToLayoutBitSet();
        this.computeFixedRowHeight();
        EventHandler<MouseEvent> ml = event -> {
            if (tableView.getEditingCell() != null) {
                tableView.edit(-1, null);
            }
            tableView.requestFocus();
        };
        this.getFlow().getVerticalBar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        this.getFlow().getHorizontalBar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        GridViewBehavior behavior = this.getBehavior();
        behavior.setOnFocusPreviousRow(() -> this.onFocusAboveCell());
        behavior.setOnFocusNextRow(() -> this.onFocusBelowCell());
        behavior.setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        behavior.setOnMoveToLastCell(() -> this.onMoveToLastCell());
        behavior.setOnScrollPageDown(isFocusDriven -> this.onScrollPageDown((boolean)isFocusDriven));
        behavior.setOnScrollPageUp(isFocusDriven -> this.onScrollPageUp((boolean)isFocusDriven));
        behavior.setOnSelectPreviousRow(() -> this.onSelectAboveCell());
        behavior.setOnSelectNextRow(() -> this.onSelectBelowCell());
        behavior.setOnSelectLeftCell(() -> this.onSelectLeftCell());
        behavior.setOnSelectRightCell(() -> this.onSelectRightCell());
        behavior.setOnFocusLeftCell(() -> this.onFocusLeftCell());
        behavior.setOnFocusRightCell(() -> this.onFocusRightCell());
        this.registerChangeListener(tableView.fixedCellSizeProperty(), var1x -> this.getFlow().setFixedCellSize(((TableView)this.getSkinnable()).getFixedCellSize()));
    }

    private TableRow<ObservableList<SpreadsheetCell>> createCell() {
        TableRow<ObservableList<SpreadsheetCell>> row = null;
        TableView tableView = (TableView)this.getSkinnable();
        row = tableView.getRowFactory().call(tableView);
        row.updateTableView(tableView);
        return row;
    }

    public double getRowHeight(int row) {
        if (row == -1) {
            return 24.0;
        }
        Double rowHeightCache = (Double)this.rowHeightMap.get(this.spreadsheetView.getModelRow(row));
        if (rowHeightCache == null) {
            double rowHeight = this.handle.getView().getGrid().getRowHeight(this.spreadsheetView.getModelRow(row));
            return rowHeight == -1.0 ? 24.0 : rowHeight;
        }
        return rowHeightCache;
    }

    public double getFixedRowHeight() {
        return this.fixedRowHeight;
    }

    public ObservableList<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    public ObservableList<Integer> getSelectedColumns() {
        return this.selectedColumns;
    }

    public GridCellEditor getSpreadsheetCellEditorImpl() {
        return this.gridCellEditor;
    }

    public GridRow getRowIndexed(int index) {
        IndexedCell cell;
        List<?> cells = this.getFlow().getCells();
        if (!cells.isEmpty() && index >= (cell = (IndexedCell)cells.get(0)).getIndex() && index - cell.getIndex() < cells.size()) {
            return (GridRow)cells.get(index - cell.getIndex());
        }
        for (IndexedCell cell2 : this.getFlow().getFixedCells()) {
            if (cell2.getIndex() != index) continue;
            return (GridRow)cell2;
        }
        return null;
    }

    public int getFirstRow(SpreadsheetCell cell, int index) {
        while (--index >= 0 && ((ObservableList)this.spreadsheetView.getItems().get(index)).get(cell.getColumn()) == cell) {
        }
        return index + 1;
    }

    public GridRow getRow(int index) {
        if (index < this.getFlow().getCells().size()) {
            return (GridRow)this.getFlow().getCells().get(index);
        }
        return null;
    }

    public final boolean containsRow(int index) {
        for (Object obj : this.getFlow().getCells()) {
            if (((GridRow)obj).getIndex() != index || !(((GridRow)obj).getLayoutY() >= 0.0)) continue;
            return true;
        }
        return false;
    }

    public int getCellsSize() {
        return this.getFlow().getCells().size();
    }

    public ScrollBar getHBar() {
        if (this.getFlow() != null) {
            return this.getFlow().getHorizontalBar();
        }
        return null;
    }

    public ScrollBar getVBar() {
        return this.getFlow().getVerticalBar();
    }

    public void resizeRowsToFitContent() {
        Grid grid = this.spreadsheetView.getGrid();
        int maxRows = this.handle.getView().getGrid().getRowCount();
        for (int row = 0; row < maxRows; ++row) {
            if (!grid.isRowResizable(row)) continue;
            this.resizeRowToFitContent(row);
        }
    }

    public void resizeRowToFitContent(int modelRow) {
        Node n;
        if (((TableView)this.getSkinnable()).getColumns().isEmpty()) {
            return;
        }
        TableColumn col = (TableColumn)((TableView)this.getSkinnable()).getColumns().get(0);
        ObservableList items = this.handle.getGridView().getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        if (!this.spreadsheetView.getGrid().isRowResizable(modelRow)) {
            return;
        }
        Callback cellFactory = col.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        CellView cell = (CellView)cellFactory.call(col);
        if (cell == null) {
            return;
        }
        cell.getProperties().put("deferToParentPrefWidth", Boolean.TRUE);
        double padding = 5.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedTopInset() + r.snappedBottomInset();
        }
        double maxHeight = 0.0;
        this.getChildren().add(cell);
        int columnSize = ((TableView)this.getSkinnable()).getColumns().size();
        for (int viewColumn = 0; viewColumn < columnSize; ++viewColumn) {
            TableColumn column = (TableColumn)((TableView)this.getSkinnable()).getColumns().get(viewColumn);
            cell.updateTableColumn(column);
            cell.updateTableView(this.handle.getGridView());
            cell.updateIndex(modelRow);
            SpreadsheetCell spc = (SpreadsheetCell)cell.getItem();
            double width = column.getWidth();
            if (spc != null && spc.getColumn() == viewColumn && spc.getColumnSpan() > 1) {
                int max = ((TableView)this.getSkinnable()).getVisibleLeafColumns().size() - viewColumn;
                int colSpan = spc.getColumnSpan();
                for (int i = 1; i < colSpan && i < max; ++i) {
                    double tempWidth = this.snapSize(((TableView)this.getSkinnable()).getVisibleLeafColumn(viewColumn + i).getWidth());
                    width += tempWidth;
                }
            }
            if (spc == null || spc.getColumn() != viewColumn || (cell.getText() == null || cell.getText().isEmpty()) && cell.getGraphic() == null) continue;
            cell.setWrapText(true);
            cell.applyCss();
            maxHeight = Math.max(maxHeight, cell.prefHeight(width));
        }
        this.getChildren().remove(cell);
        this.rowHeightMap.put(modelRow, maxHeight + padding);
        Event.fireEvent(this.spreadsheetView, new SpreadsheetView.RowHeightEvent(modelRow, maxHeight + padding));
        this.rectangleSelection.updateRectangle();
    }

    public void resizeRowsToMaximum() {
        this.resizeRowsToFitContent();
        Grid grid = this.spreadsheetView.getGrid();
        double maxHeight = 0.0;
        Iterator iterator = this.rowHeightMap.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            maxHeight = Math.max(maxHeight, (Double)this.rowHeightMap.get(key));
        }
        this.rowHeightMap.clear();
        int maxRows = this.handle.getView().getGrid().getRows().size();
        for (int modelRow = 0; modelRow < maxRows; ++modelRow) {
            if (!grid.isRowResizable(modelRow)) continue;
            Event.fireEvent(this.spreadsheetView, new SpreadsheetView.RowHeightEvent(modelRow, maxHeight));
            this.rowHeightMap.put(modelRow, maxHeight);
        }
        this.rectangleSelection.updateRectangle();
    }

    public void resizeRowsToDefault() {
        this.rowHeightMap.clear();
        Grid grid = this.spreadsheetView.getGrid();
        for (GridRow row : this.getFlow().getCells()) {
            if (!grid.isRowResizable(this.spreadsheetView.getModelRow(row.getIndex()))) continue;
            double newHeight = row.computePrefHeight(-1.0);
            if (row.getPrefHeight() == newHeight) continue;
            row.setRowHeight(newHeight);
            row.requestLayout();
        }
        this.getFlow().layoutChildren();
        for (GridRow row : this.getFlow().getCells()) {
            double height = this.getRowHeight(this.spreadsheetView.getModelRow(row.getIndex()));
            if (row.getHeight() == height || !grid.isRowResizable(this.spreadsheetView.getModelRow(row.getIndex()))) continue;
            row.setRowHeight(height);
        }
        this.rectangleSelection.updateRectangle();
    }

    public void resizeColumnToFitContent(TableColumn<ObservableList<SpreadsheetCell>, ?> tc, int maxRows) {
        Node n;
        TableColumn<ObservableList<SpreadsheetCell>, ?> col = tc;
        ObservableList items = this.handle.getGridView().getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        Callback<TableColumn<ObservableList<SpreadsheetCell>, ?>, TableCell<ObservableList<SpreadsheetCell>, ?>> cellFactory = col.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        TableCell<ObservableList<SpreadsheetCell>, ?> cell = cellFactory.call(col);
        if (cell == null) {
            return;
        }
        int indexColumn = this.handle.getGridView().getColumns().indexOf(tc);
        if (maxRows == 30 && this.handle.isColumnWidthSet(indexColumn)) {
            return;
        }
        double padding = ((SpreadsheetColumn)this.spreadsheetView.getColumns().get(indexColumn)).getFilter() != null ? 0.0 : 10.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedLeftInset() + r.snappedRightInset();
        }
        cell.getProperties().put("deferToParentPrefWidth", Boolean.TRUE);
        ObservableList<ObservableList<SpreadsheetCell>> gridRows = this.spreadsheetView.getGrid().getRows();
        int rows = maxRows == -1 ? items.size() : Math.min(items.size(), maxRows == 30 ? 100 : maxRows);
        double maxWidth = 0.0;
        boolean datePresent = false;
        cell.updateTableColumn(col);
        cell.updateTableView(this.handle.getGridView());
        if (cell.getSkin() == null) {
            cell.setSkin(new CellViewSkin((CellView)cell));
        }
        for (int row = 0; row < rows; ++row) {
            cell.updateIndex(row);
            if ((cell.getText() == null || cell.getText().isEmpty()) && cell.getGraphic() == null) continue;
            this.getChildren().add(cell);
            if (((SpreadsheetCell)cell.getItem()).getItem() instanceof LocalDate) {
                datePresent = true;
            }
            cell.applyCss();
            double width = cell.prefWidth(-1.0);
            SpreadsheetCell spc = (SpreadsheetCell)((ObservableList)gridRows.get(row)).get(indexColumn);
            if (this.spreadsheetView.getColumnSpan(spc) > 1) {
                for (int i = this.spreadsheetView.getViewColumn(spc.getColumn()); i < this.spreadsheetView.getViewColumn(spc.getColumn()) + this.spreadsheetView.getColumnSpan(spc); ++i) {
                    if (i == indexColumn) continue;
                    width -= ((SpreadsheetColumn)this.spreadsheetView.getColumns().get(i)).getWidth();
                }
            }
            maxWidth = Math.max(maxWidth, width);
            this.getChildren().remove(cell);
        }
        cell.updateIndex(-1);
        double widthMax = maxWidth + padding;
        if (this.handle.getGridView().getColumnResizePolicy() == TableView.CONSTRAINED_RESIZE_POLICY) {
            widthMax = Math.max(widthMax, col.getWidth());
        }
        if (datePresent && widthMax < DATE_CELL_MIN_WIDTH) {
            widthMax = DATE_CELL_MIN_WIDTH;
        }
        widthMax = this.snapSize(widthMax);
        if (col.getPrefWidth() != widthMax || col.getWidth() == widthMax) {
            col.setPrefWidth(widthMax);
        }
        this.rectangleSelection.updateRectangle();
    }

    protected final void init() {
        this.rectangleSelection = new RectangleSelection(this, (TableViewSpanSelectionModel)this.handle.getGridView().getSelectionModel());
        this.getFlow().getVerticalBar().valueProperty().addListener(this.vbarValueListener);
        this.verticalHeader = new VerticalHeader(this.handle);
        this.getChildren().add(this.verticalHeader);
        ((HorizontalHeader)this.getTableHeaderRow()).init();
        this.verticalHeader.init(this, (HorizontalHeader)this.getTableHeaderRow());
        this.horizontalPickers = new HorizontalPicker((HorizontalHeader)this.getTableHeaderRow(), this.spreadsheetView);
        this.getChildren().add(this.horizontalPickers);
        this.getFlow().init(this.spreadsheetView);
        this.getBehavior().setGridViewSkin(this);
    }

    public GridViewBehavior getBehavior() {
        return this.behavior;
    }

    protected final ObservableSet<Integer> getCurrentlyFixedRow() {
        return this.currentlyFixedRow;
    }

    public ObservableList<TableColumn<ObservableList<SpreadsheetCell>, ?>> getColumns() {
        return this.handle.getGridView().getColumns();
    }

    public void resize(TableColumnBase<?, ?> tc, int maxRows) {
        if (tc.isResizable()) {
            int columnIndex = this.getColumns().indexOf(tc);
            TableColumn tableColumn = (TableColumn)this.getColumns().get(columnIndex);
            this.resizeColumnToFitContent(tableColumn, maxRows);
            Event.fireEvent(this.spreadsheetView, new SpreadsheetView.ColumnWidthEvent(columnIndex, tableColumn.getWidth()));
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double horizontalPickerHeight;
        if (this.spreadsheetView == null) {
            return;
        }
        double verticalHeaderWidth = this.verticalHeader.computeHeaderWidth();
        double d = horizontalPickerHeight = this.spreadsheetView.getColumnPickers().isEmpty() ? 0.0 : 16.0;
        if (this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) {
            x += verticalHeaderWidth;
            w -= verticalHeaderWidth;
        } else {
            x = 0.0;
        }
        super.layoutChildren(x, y += horizontalPickerHeight, w, h - horizontalPickerHeight);
        double baselineOffset = ((TableView)this.getSkinnable()).getLayoutBounds().getHeight() / 2.0;
        double tableHeaderRowHeight = 0.0;
        if (!this.spreadsheetView.getColumnPickers().isEmpty()) {
            this.layoutInArea(this.horizontalPickers, x, y - 16.0, w, tableHeaderRowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
        }
        if (this.spreadsheetView.showColumnHeaderProperty().get()) {
            tableHeaderRowHeight = this.getTableHeaderRow().prefHeight(-1.0);
            tableHeaderRowHeight = tableHeaderRowHeight < 24.0 ? 24.0 : tableHeaderRowHeight;
            this.layoutInArea(this.getTableHeaderRow(), x, y, w, tableHeaderRowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
            y += tableHeaderRowHeight;
        }
        if (this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) {
            this.layoutInArea(this.verticalHeader, x - verticalHeaderWidth, y - tableHeaderRowHeight, w, h, baselineOffset, HPos.CENTER, VPos.CENTER);
        }
    }

    @Override
    protected void onFocusAboveCell() {
        this.focusScroll();
    }

    @Override
    protected void onFocusBelowCell() {
        this.focusScroll();
    }

    private int getFixedRowSize() {
        int i = 0;
        for (Integer fixedRow : this.spreadsheetView.getFixedRows()) {
            if (this.spreadsheetView.getHiddenRows().get(fixedRow)) continue;
            ++i;
        }
        return i;
    }

    void focusScroll() {
        TableView.TableViewFocusModel fm = this.handle.getGridView().getFocusModel();
        if (fm == null) {
            return;
        }
        int row = fm.getFocusedIndex();
        this.getFlow().scrollTo(row);
        this.scrollHorizontally();
    }

    @Override
    protected void onSelectAboveCell() {
        super.onSelectAboveCell();
        this.scrollHorizontally();
    }

    @Override
    protected void onSelectBelowCell() {
        super.onSelectBelowCell();
        this.scrollHorizontally();
    }

    @Override
    protected VirtualFlow<TableRow<ObservableList<SpreadsheetCell>>> createVirtualFlow() {
        return new GridVirtualFlow<TableRow<ObservableList<SpreadsheetCell>>>(this);
    }

    @Override
    protected TableHeaderRow createTableHeaderRow() {
        return new HorizontalHeader(this);
    }

    public HorizontalHeader getHorizontalHeader() {
        return (HorizontalHeader)this.getTableHeaderRow();
    }

    @Override
    public void scrollHorizontally() {
        super.scrollHorizontally();
    }

    @Override
    protected void scrollHorizontally(TableColumn<ObservableList<SpreadsheetCell>, ?> col) {
        if (col == null || !col.isVisible()) {
            return;
        }
        this.fixedColumnWidth = 0.0;
        double pos = this.getFlow().getHorizontalBar().getValue();
        int index = this.getColumns().indexOf(col);
        double start = 0.0;
        for (int columnIndex = 0; columnIndex < index; ++columnIndex) {
            if (this.spreadsheetView.isColumnHidden(columnIndex)) continue;
            SpreadsheetColumn column = (SpreadsheetColumn)this.spreadsheetView.getColumns().get(columnIndex);
            if (column.isFixed()) {
                this.fixedColumnWidth += column.getWidth();
            }
            start += column.getWidth();
        }
        double end = start + col.getWidth();
        double headerWidth = this.handle.getView().getWidth() - this.snappedLeftInset() - this.snappedRightInset() - this.verticalHeader.getVerticalHeaderWidth();
        double max = this.getFlow().getHorizontalBar().getMax();
        if (start < pos + this.fixedColumnWidth && start >= 0.0 && start >= this.fixedColumnWidth) {
            double newPos = start - this.fixedColumnWidth < 0.0 ? start : start - this.fixedColumnWidth;
            this.getFlow().getHorizontalBar().setValue(newPos);
        } else if (start > pos + headerWidth) {
            double delta = start < 0.0 || end > headerWidth ? start - pos - this.fixedColumnWidth : 0.0;
            double newPos = pos + delta > max ? max : pos + delta;
            this.getFlow().getHorizontalBar().setValue(newPos);
        }
    }

    private void verticalScroll() {
        this.verticalHeader.requestLayout();
    }

    GridVirtualFlow<?> getFlow() {
        return (GridVirtualFlow)this.getVirtualFlow();
    }

    private BitSet initRowToLayoutBitSet() {
        int rowCount = this.getItemCount();
        BitSet bitSet = new BitSet(rowCount);
        block0: for (int row = 0; row < rowCount; ++row) {
            if (this.spreadsheetView.getFixedRows().contains(this.spreadsheetView.getModelRow(row))) {
                bitSet.set(row);
                continue;
            }
            List myRow = (List)this.handle.getGridView().getItems().get(row);
            for (SpreadsheetCell cell : myRow) {
                if (this.spreadsheetView.getRowSpanFilter(cell) <= 1) continue;
                bitSet.set(row);
                continue block0;
            }
        }
        return bitSet;
    }

    public void computeFixedRowHeight() {
        this.fixedRowHeight = 0.0;
        Iterator iterator = this.getCurrentlyFixedRow().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.fixedRowHeight += this.getRowHeight(i);
        }
    }

    @Override
    public final int getItemCount() {
        return ((TableView)this.getSkinnable()).getItems() == null ? 0 : ((TableView)this.getSkinnable()).getItems().size();
    }

    public void setHbarValue(double value) {
        this.setHbarValue(value, 0);
    }

    public void setHbarValue(double value, int count) {
        if (count > 5) {
            return;
        }
        int newCount = count + 1;
        if (this.getFlow().getScene() == null) {
            Platform.runLater(() -> this.setHbarValue(value, newCount));
            return;
        }
        this.getHBar().setValue(value);
    }
}

